﻿Public Class ExplosionParticleSystem
    Inherits ParticleSystem

    Sub New(g As Game, howManyEffects As Integer, r As Random, spriteBatch As SpriteBatch, world As VirtualWorld)
        MyBase.New(g, howManyEffects, r, spriteBatch, world)
    End Sub

    Protected Overrides Sub InitializeConstants()
        Me.TextureFileName = "Textures/Explosion"
        'high initial speed with lots of variance.  make the values closer
        ' together to have more consistently circular explosions.
        MinInitialSpeed = 40
        MaxInitialSpeed = 100

        ' doesn't matter what these values are set to, acceleration is tweaked in
        ' the override of InitializeParticle.
        MinAcceleration = 0
        MaxAcceleration = 0

        ' explosions should be relatively short lived
        MinLifeTime = 0.5F
        MaxLifeTime = 1.0F

        'MinScale = 0.3F
        'MaxScale = 1.0F
        MinScale = 0.1F
        MaxScale = 0.3F

        Me.MinNumberParticles = 20
        Me.MaxNumberParticles = 25

        MinRotationSpeed = -MathHelper.PiOver4
        MaxRotationSpeed = MathHelper.PiOver4

        ' additive blending is very good at creating fiery effects.
        BlendState = BlendState.Additive

        'Me.DrawOrder = AdditiveDrawOrder
        Me.DrawOrder = 1

    End Sub

    Protected Overrides Sub InitializeParticle(p As Particle, where As Microsoft.Xna.Framework.Vector2)
        MyBase.InitializeParticle(p, where)
        p.Acceleration = -p.Velocity / p.LifeTime
    End Sub
End Class
